function [Ce,De] = bfor_endogenous_ms_solver_matrices_e(nderivs,ns,G)
% 
% Returns the matrices Cc and Dc for solving the first order derivative
%   with respect to epsilon
% 
% Updated 2020/12
% Benigno, Foerster, Otrok, and Rebucci
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %
% 
%  INPUTS
%  nderivs  = structure with elements of the first and second derivatives
%               of f with respect to vars, and first derivatives of Pmat
%               with respect to vars; both evaluated at steady state  
%  ns       = number of regimes
%  G        = (ny x (nx+ne+1) x ns) array for first-order solution for the 
%               predetermined variables, G(i,j,s) is the response of y(i) 
%               to state(j) conditional on regime s, state=[xlag;epsilon;chi]
%  
%  OUTPUTS
%   Ce      = {ns x ns) cell of derivative coefficients for solving the
%               system
%   De      = {ns x ns) cell of constants for solving the system
% 
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %

% -- Other Setup -- %
nx = size(nderivs.dfx{1,1},2);
Ce = cell(ns,ns);
De = cell(ns,ns);

for s = 1:ns
    for sp = 1:ns        
        dfyp      = nderivs.dfyp{sp,s};
        dfy       = nderivs.dfy{sp,s};
        dfx       = nderivs.dfx{sp,s};
        dfe       = nderivs.dfe{sp,s};
        
        Ce{sp,s} = [dfx+dfyp*G(:,1:nx,sp) dfy];
        De{sp,s} = dfe;
        
    end
end
